/// <reference path="jquery-2.0.2-vsdoc.js"/>
// NOTE: Adding the VSDOC reference for jQuery provides Visual Studio with jQuery intellisence

// Our function to initialize the content of the image carousel
function InitializeImageCarousel() {
    // Get the current SharePoint Context
    var context = new SP.ClientContext.get_current();

    // Get the current SharePoint Site
    var web = context.get_web();

    // Get the Images list from the Site
    var list = web.get_lists().getByTitle('Images');

    // Use a CAML query to limit the returned items to 5
    var camlQuery = new SP.CamlQuery();
    camlQuery.set_viewXml('<View><RowLimit>5</RowLimit></View>');

    // Get the items from the list with the CAML query
    var items = list.getItems(camlQuery);

    // Instruct the context to load the items with the Id, Title, and FileRef properties
    context.load(items, 'Include(Id, Title, FileRef)');

    // Execute the query
    context.executeQueryAsync(
        // Use a delegate function to handle the successful query
        Function.createDelegate(this, function (sender, args) {

            // Create the UL container object for the slider
            var slider = $('<ul class="bxslider"></ul>');

            // Iterate through each item
            var listItemEnumerator = items.getEnumerator();
            while (listItemEnumerator.moveNext()) {
                var oListItem = listItemEnumerator.get_current();

                // Create the HTML for displaying the image and add it to the UL container
                var itemHtml = $('<li><img title="' + oListItem.get_item("Title") + '" src="' + oListItem.get_item("FileRef") + '" /></li>');
                itemHtml.appendTo(slider);
            }            

            // Add the UL slider container to the ImageCarousel DIV we have on the page
            var imageCarousel = $('.ImageCarousel');
            slider.appendTo(imageCarousel);

            // Initialize the slider plugin
            $('.bxslider').bxSlider({ captions: true, slideWidth: 750 });

            // Set the height of the ImageCarousel DIV to match the slider to ensure there is no overlapping content
            $('.ImageCarousel').height($('.bx-wrapper', $('.ImageCarousel')).height());
        }),
        // Use a delegate function to handle the failed query
        Function.createDelegate(this, function (sender, args) {
            // Use SharePoint's debug tracing to log the error to the browser console
            Sys.Debug.trace('Request failed. ' + args.get_message() + '\n' + args.get_stackTrace());
    }));        
    
}

// Instruct our initialization function to load once sp.js has been loaded
ExecuteOrDelayUntilScriptLoaded(InitializeImageCarousel, "sp.js");